## Pipelines again

In this exercise, we write points and pipes of a
diagram in the same format used earlier for reading.

### Step 1

Use

::value[Simantics/DB/relativeResource]

and 

::value[Simantics/DB/currentModel]

to define a variable `dia` that refers to some composite (configuration element
corresponding to a diagram). Create some content (points and pipes) to
the diagram.

Print the value to the console and check that it corresponds to the
resource id given by the graph debugger.

### Step 2

Import the ontology `http://www.simantics.org/Layer0-1.1` as `L0`.

Use 

::value[Simantics/DB/#]

and `L0.ConsistsOf` to find all children of `dia`.
Print their names using

::value[Prelude/map, Simantics/DB/nameOf]

### Step 3

Import the ontology `http://www.apros.fi/Combustion/Configuration-6.0` as `Conf`.

Modify the commands in step 2 to find only the points (`Conf.ModuleTypes.POINT`) of the diagram. 

### Step 4 

Print the names and elevations of all points in `dia` using the function

::value[Simantics/DB/relatedValue]

and the attribute `Conf.Relations.PO11_ELEV`.

### Step 5 

Use the relation `http://www.simantics.org/Modeling-1.2/ElementToComponent`
and 

::value[Simantics/DB/singleObject]

to find the graphical symbol of the point.

Use the relation `http://www.simantics.org/Diagram-2.2/HasTransform` and

::value[Simantics/DB/relatedValue]

to read the transformation of the point. The last two elements of the transformation
are the coordinates of the point.

### Step 6

Give an indices for all points you find for example using

::value[Prelude/range, Prelude/zip]

### Step 7

Print the data about the points in the format described in
the previous pipelines exercise.

### Step 8

Print the corresponding data about the pipes.